/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.utils;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import dev.kostromdan.mods.crash_assistant.app.CrashAssistantApp;
import dev.kostromdan.mods.crash_assistant.common_config.platform.PlatformHelp;
import java.io.IOException;
import java.io.StringReader;
import java.lang.invoke.CallSite;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TerminatedProcessesFinder {
    private static volatile Wevtapi WEVT;
    private static final DateTimeFormatter HUMAN_TIME_FMT;
    private static final String SEPARATOR = "-----------------------";
    private static final BigInteger FILETIME_EPOCH_DELTA_100NS;
    private static final BigInteger HNS_PER_MS;
    private static final Pattern RX_FAULT_PID;
    private static final Pattern RX_FAULT_STARTTIME;
    private static final Pattern RX_EXCEPTION_CODE;
    private static final Pattern RX_NVIDIA_PID_TID;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Wevtapi wevt() {
        if (WEVT != null) return WEVT;
        Class<TerminatedProcessesFinder> clazz = TerminatedProcessesFinder.class;
        synchronized (TerminatedProcessesFinder.class) {
            if (WEVT != null) return WEVT;
            try {
                if (!PlatformHelp.isWindows()) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return null;
                }
                try {
                    Method m = Native.class.getMethod("load", String.class, Class.class);
                    WEVT = (Wevtapi)m.invoke(null, "wevtapi", Wevtapi.class);
                }
                catch (NoSuchMethodException ignored) {
                    WEVT = (Wevtapi)Native.loadLibrary((String)"wevtapi", Wevtapi.class);
                }
            }
            catch (Throwable t) {
                throw new UnsatisfiedLinkError("Failed to load wevtapi via JNA: " + String.valueOf(t));
            }
            return WEVT;
        }
    }

    public static String getTerminatedByWinProcessLogs() {
        String fileName = "win_event" + System.currentTimeMillis() + ".txt";
        Path targetPath = Paths.get(fileName, new String[0]);
        try {
            if (!PlatformHelp.isWindows()) {
                return fileName;
            }
            List<String> blocks = TerminatedProcessesFinder.queryRecentAppLog(15000L);
            if (blocks.isEmpty()) {
                return fileName;
            }
            String header = "Detected that Windows reported recent critical or error events in the Application log,\nwhich can indicate that a process (including the Minecraft JVM) terminated unexpectedly.\nScope: Application log; Levels: Error & Critical; Window: last ~15 seconds.\n\nIf no java.exe (or related JVM processes) are listed below, you can disregard this message.\nTo inspect these events manually:\n  1) Press Win+R, type \"eventvwr.msc\", press Enter.\n  2) Open \"Windows Logs\" \u2192 \"Application\".\n  3) Sort by Date and look for entries with Level = Error or Critical near the crash time.\n";
            StringBuilder out = new StringBuilder();
            out.append(header).append("\n");
            for (String block : blocks) {
                out.append(SEPARATOR).append("\n").append(block).append("\n").append(SEPARATOR).append("\n\n");
            }
            Files.write(targetPath, out.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (Throwable t) {
            try {
                CrashAssistantApp.LOGGER.error("TerminatedProcessesFinder: Windows Event Log query failed.", t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> queryRecentAppLog(long maxAgeMillis) throws Exception {
        ArrayList<String> results = new ArrayList<String>();
        String xpath = "*[System[(Level=1 or Level=2) and TimeCreated[timediff(@SystemTime) <= " + maxAgeMillis + "]]]";
        Wevtapi api = TerminatedProcessesFinder.wevt();
        if (api == null) {
            return results;
        }
        WinNT.HANDLE query = api.EvtQuery(null, new WString("Application"), new WString(xpath), 1);
        if (query == null) {
            throw new IOException("EvtQuery returned null for Application log.");
        }
        try {
            WinNT.HANDLE[] events = new WinNT.HANDLE[32];
            IntByReference returned = new IntByReference(0);
            while (api.EvtNext(query, events.length, events, 0, 0, returned)) {
                int count = returned.getValue();
                for (int i = 0; i < count; ++i) {
                    WinNT.HANDLE evt = events[i];
                    try {
                        String xml = TerminatedProcessesFinder.renderEventXml(api, evt);
                        EventInfo info = TerminatedProcessesFinder.parseEventXml(xml);
                        String message = TerminatedProcessesFinder.formatMessage(api, evt, info.providerName);
                        String block = TerminatedProcessesFinder.renderBlock(info, message);
                        results.add(block);
                        continue;
                    }
                    finally {
                        TerminatedProcessesFinder.safeClose(api, events[i]);
                        events[i] = null;
                    }
                }
                returned.setValue(0);
            }
        }
        finally {
            TerminatedProcessesFinder.safeClose(api, query);
        }
        return results;
    }

    private static String renderEventXml(Wevtapi api, WinNT.HANDLE evt) throws IOException {
        IntByReference used = new IntByReference(0);
        IntByReference count = new IntByReference(0);
        api.EvtRender(null, evt, 1, 0, Pointer.NULL, used, count);
        int needed = used.getValue();
        if (needed <= 0) {
            throw new IOException("EvtRender size was non-positive.");
        }
        Memory buf = new Memory((long)needed);
        if (!api.EvtRender(null, evt, 1, (int)buf.size(), (Pointer)buf, used, count)) {
            throw new IOException("EvtRender failed.");
        }
        return buf.getWideString(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String formatMessage(Wevtapi api, WinNT.HANDLE evt, String providerName) {
        if (providerName == null || providerName.isEmpty()) {
            return "";
        }
        WinNT.HANDLE meta = api.EvtOpenPublisherMetadata(null, new WString(providerName), null, 0, 0);
        if (meta == null) {
            return "";
        }
        try {
            char[] buf;
            IntByReference used = new IntByReference(0);
            boolean ok = api.EvtFormatMessage(meta, evt, 0, 0, null, 1, 0, null, used);
            int needed = used.getValue();
            if (!ok && needed > 0 && (ok = api.EvtFormatMessage(meta, evt, 0, 0, null, 1, needed, buf = new char[needed], used))) {
                String string = new String(buf, 0, used.getValue()).trim();
                return string;
            }
            String string = "";
            return string;
        }
        catch (Throwable ignored) {
            String string = "";
            return string;
        }
        finally {
            TerminatedProcessesFinder.safeClose(api, meta);
        }
    }

    private static void safeClose(Wevtapi api, WinNT.HANDLE h) {
        try {
            if (h != null) {
                api.EvtClose(h);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static EventInfo parseEventXml(String xml) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(new InputSource(new StringReader(xml)));
        EventInfo info = new EventInfo();
        Element root = doc.getDocumentElement();
        NodeList systemList = root.getElementsByTagName("System");
        if (systemList.getLength() > 0) {
            Node levelNode;
            Node timeCreated;
            Node eventId;
            Element sys = (Element)systemList.item(0);
            Node provider = sys.getElementsByTagName("Provider").item(0);
            if (provider instanceof Element) {
                info.providerName = ((Element)provider).getAttribute("Name");
            }
            if ((eventId = sys.getElementsByTagName("EventID").item(0)) != null) {
                info.eventId = eventId.getTextContent();
            }
            if ((timeCreated = sys.getElementsByTagName("TimeCreated").item(0)) instanceof Element) {
                info.timeIso = ((Element)timeCreated).getAttribute("SystemTime");
            }
            if ((levelNode = sys.getElementsByTagName("Level").item(0)) != null) {
                info.level = TerminatedProcessesFinder.levelCodeToName(levelNode.getTextContent());
            }
        }
        int unnamed = 0;
        NodeList dataBlocks = root.getElementsByTagName("EventData");
        if (dataBlocks.getLength() == 0) {
            dataBlocks = root.getElementsByTagName("UserData");
        }
        for (int i = 0; i < dataBlocks.getLength(); ++i) {
            Node n = dataBlocks.item(i);
            NodeList children = n.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Node c = children.item(j);
                if (!(c instanceof Element)) continue;
                Element e = (Element)c;
                if ("Data".equals(e.getNodeName())) {
                    String val;
                    Object name = e.getAttribute("Name");
                    if (name == null || ((String)name).trim().isEmpty()) {
                        name = "Data[" + ++unnamed + "]";
                    }
                    if ((val = e.getTextContent()) == null || val.trim().isEmpty()) continue;
                    info.pairs.add(new KV((String)name, val.trim()));
                    continue;
                }
                String val = e.getTextContent();
                if (val == null || val.trim().isEmpty()) continue;
                info.pairs.add(new KV(e.getTagName(), val.trim()));
            }
        }
        return info;
    }

    private static String levelCodeToName(String codeStr) {
        try {
            int code = Integer.parseInt(codeStr.trim());
            switch (code) {
                case 1: {
                    return "Critical";
                }
                case 2: {
                    return "Error";
                }
                case 3: {
                    return "Warning";
                }
                case 4: {
                    return "Information";
                }
                case 5: {
                    return "Verbose";
                }
            }
            return "Level " + code;
        }
        catch (Exception e) {
            return codeStr;
        }
    }

    private static String renderBlock(EventInfo info, String message) {
        StringBuilder b = new StringBuilder();
        if (info.timeIso != null && !info.timeIso.isEmpty()) {
            try {
                Instant instant = Instant.parse(info.timeIso);
                ZonedDateTime zdt = instant.atZone(ZoneId.systemDefault());
                b.append("Time: ").append(HUMAN_TIME_FMT.format(zdt));
            }
            catch (Exception e) {
                b.append("Time: ").append(info.timeIso);
            }
            b.append("\n");
        }
        if (info.providerName != null) {
            b.append("Source: ").append(info.providerName).append("\n");
        }
        if (info.eventId != null) {
            b.append("Event ID: ").append(info.eventId).append("\n");
        }
        if (info.level != null) {
            b.append("Level: ").append(info.level).append("\n");
        }
        if (message != null && !message.isEmpty()) {
            b.append("\nMessage:\n");
            b.append(TerminatedProcessesFinder.indent(TerminatedProcessesFinder.cleanMultiline(message))).append("\n");
        }
        ArrayList<CallSite> detail = new ArrayList<CallSite>();
        HashSet<String> seen = new HashSet<String>();
        for (KV kv : info.pairs) {
            String string = kv.key;
            String v = kv.value;
            String kl = string.toLowerCase(Locale.ROOT);
            seen.add(kl);
            if (kl.contains("process id") || kl.equals("pid") || kl.equals("processid")) {
                String norm = TerminatedProcessesFinder.normalizePid(v);
                if (norm != null) {
                    detail.add((CallSite)((Object)("  - Process ID: " + norm + " [" + v + "]")));
                    continue;
                }
                detail.add((CallSite)((Object)("  - " + string + ": " + v)));
                continue;
            }
            if (kl.contains("start time") || kl.contains("starttime")) {
                DecTime dt = TerminatedProcessesFinder.normalizeFiletime(v);
                if (dt != null) {
                    detail.add((CallSite)((Object)("  - Start Time: " + (dt.human != null ? dt.human : "") + " [" + dt.raw + "]")));
                    continue;
                }
                detail.add((CallSite)((Object)("  - " + string + ": " + v)));
                continue;
            }
            if (kl.contains("exception code")) {
                DecHex dh = TerminatedProcessesFinder.normalizeHexOrDec(v);
                if (dh != null) {
                    detail.add((CallSite)((Object)("  - Exception Code: " + dh.dec + " [" + dh.hex + "]")));
                    continue;
                }
                detail.add((CallSite)((Object)("  - " + string + ": " + v)));
                continue;
            }
            detail.add((CallSite)((Object)("  - " + string + ": " + v)));
        }
        Derived d = TerminatedProcessesFinder.deriveFromMessage(message);
        if (d != null) {
            if (d.pidDec != null) {
                detail.add((CallSite)((Object)("  - Process ID: " + d.pidDec + (String)(d.pidHex != null ? " [" + d.pidHex + "]" : ""))));
            }
            if (d.tidDec != null) {
                detail.add((CallSite)((Object)("  - Thread ID: " + d.tidDec)));
            }
            if (d.startTime != null) {
                detail.add((CallSite)((Object)("  - Start Time: " + (d.startTime.human != null ? d.startTime.human : "") + " [" + d.startTime.raw + "]")));
            }
            if (d.exception != null) {
                detail.add((CallSite)((Object)("  - Exception Code: " + d.exception.dec + " [" + d.exception.hex + "]")));
            }
        }
        if (!detail.isEmpty()) {
            b.append("\nDetails:\n");
            for (String string : detail) {
                b.append(string).append("\n");
            }
        }
        return b.toString().trim();
    }

    private static Derived deriveFromMessage(String msg) {
        Matcher mNv;
        String raw;
        DecHex dh;
        Matcher mExc;
        String raw2;
        DecTime dt;
        Matcher mTime;
        String raw3;
        Long dec;
        if (msg == null || msg.isEmpty()) {
            return null;
        }
        Derived d = new Derived();
        Matcher mPid = RX_FAULT_PID.matcher(msg);
        if (mPid.find() && (dec = TerminatedProcessesFinder.parseMaybeHexToLong(raw3 = mPid.group(1))) != null) {
            d.pidDec = dec;
            if (raw3.startsWith("0x") || raw3.startsWith("0X")) {
                d.pidHex = raw3;
            }
        }
        if ((mTime = RX_FAULT_STARTTIME.matcher(msg)).find() && (dt = TerminatedProcessesFinder.normalizeFiletime(raw2 = mTime.group(1))) != null) {
            d.startTime = dt;
        }
        if ((mExc = RX_EXCEPTION_CODE.matcher(msg)).find() && (dh = TerminatedProcessesFinder.normalizeHexOrDec(raw = mExc.group(1))) != null) {
            d.exception = dh;
        }
        if ((mNv = RX_NVIDIA_PID_TID.matcher(msg)).find()) {
            try {
                d.pidDec = Long.parseLong(mNv.group(1));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                d.tidDec = Long.parseLong(mNv.group(2));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return d;
    }

    private static String normalizePid(String raw) {
        Long dec = TerminatedProcessesFinder.parseMaybeHexToLong(raw);
        return dec == null ? null : dec.toString();
    }

    private static DecHex normalizeHexOrDec(String raw) {
        if (raw == null || raw.trim().isEmpty()) {
            return null;
        }
        String t = raw.trim();
        DecHex dh = new DecHex();
        try {
            if (t.startsWith("0x") || t.startsWith("0X")) {
                long val = Long.parseUnsignedLong(t.substring(2), 16);
                dh.dec = Long.toUnsignedString(val);
                dh.hex = t;
            } else {
                long val = Long.parseLong(t);
                dh.dec = Long.toString(val);
                dh.hex = "0x" + Long.toHexString(val);
            }
            return dh;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static DecTime normalizeFiletime(String raw) {
        long millis;
        BigInteger ticks;
        if (raw == null || raw.trim().isEmpty()) {
            return null;
        }
        String t = raw.trim();
        try {
            ticks = t.startsWith("0x") || t.startsWith("0X") ? new BigInteger(t.substring(2), 16) : new BigInteger(t);
        }
        catch (Exception e) {
            return null;
        }
        BigInteger sinceUnix100ns = ticks.subtract(FILETIME_EPOCH_DELTA_100NS);
        BigInteger millisBI = sinceUnix100ns.divide(HNS_PER_MS);
        try {
            millis = millisBI.longValue();
        }
        catch (Exception e) {
            return null;
        }
        String human = HUMAN_TIME_FMT.format(Instant.ofEpochMilli(millis).atZone(ZoneId.systemDefault()));
        DecTime dt = new DecTime();
        dt.decTicks = ticks.toString();
        dt.human = human;
        dt.raw = t;
        return dt;
    }

    private static String cleanMultiline(String s) {
        return s.replace("\r\n", "\n").replace("\r", "\n").trim();
    }

    private static String indent(String s) {
        String[] lines = s.split("\n");
        StringBuilder out = new StringBuilder();
        for (String line : lines) {
            out.append("  ").append(line).append("\n");
        }
        return out.toString();
    }

    private static Long parseMaybeHexToLong(String s) {
        try {
            String t = s.trim();
            if (t.startsWith("0x") || t.startsWith("0X")) {
                return Long.parseUnsignedLong(t.substring(2), 16);
            }
            return Long.parseLong(t);
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        HUMAN_TIME_FMT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS z");
        FILETIME_EPOCH_DELTA_100NS = BigInteger.valueOf(116444736000000000L);
        HNS_PER_MS = BigInteger.valueOf(10000L);
        RX_FAULT_PID = Pattern.compile("(?i)\\bfaulting\\s+process\\s+id\\s*:\\s*(0x[0-9a-fA-F]+|\\d+)");
        RX_FAULT_STARTTIME = Pattern.compile("(?i)\\bfaulting\\s+application\\s+start\\s+time\\s*:\\s*(0x[0-9a-fA-F]+|\\d+)");
        RX_EXCEPTION_CODE = Pattern.compile("(?i)\\bexception\\s+code\\s*:\\s*(0x[0-9a-fA-F]+|\\d+)");
        RX_NVIDIA_PID_TID = Pattern.compile("\\(pid=(\\d+)\\s+tid=(\\d+)\\s+([^\\)]+)\\)");
    }

    static interface Wevtapi
    extends Library {
        public static final int EvtQueryChannelPath = 1;
        public static final int EvtRenderEventXml = 1;
        public static final int EvtFormatMessageEvent = 1;

        public WinNT.HANDLE EvtQuery(WinNT.HANDLE var1, WString var2, WString var3, int var4);

        public boolean EvtNext(WinNT.HANDLE var1, int var2, WinNT.HANDLE[] var3, int var4, int var5, IntByReference var6);

        public boolean EvtRender(WinNT.HANDLE var1, WinNT.HANDLE var2, int var3, int var4, Pointer var5, IntByReference var6, IntByReference var7);

        public WinNT.HANDLE EvtOpenPublisherMetadata(WinNT.HANDLE var1, WString var2, WString var3, int var4, int var5);

        public boolean EvtFormatMessage(WinNT.HANDLE var1, WinNT.HANDLE var2, int var3, int var4, Pointer var5, int var6, int var7, char[] var8, IntByReference var9);

        public boolean EvtClose(WinNT.HANDLE var1);
    }

    private static class EventInfo {
        String providerName;
        String level;
        String eventId;
        String timeIso;
        List<KV> pairs = new ArrayList<KV>();

        private EventInfo() {
        }
    }

    private static class KV {
        String key;
        String value;

        KV(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }

    private static class DecTime {
        String decTicks;
        String human;
        String raw;

        private DecTime() {
        }
    }

    private static class DecHex {
        String dec;
        String hex;

        private DecHex() {
        }
    }

    private static class Derived {
        Long pidDec;
        String pidHex;
        Long tidDec;
        DecTime startTime;
        DecHex exception;

        private Derived() {
        }
    }
}

